
/* Copyright (C) 2001-2008 Monotype Imaging Inc. All rights reserved. */

/* Confidential information of Monotype Imaging Inc. */

/* fs_typeset.c */

#include "fs_itype.h"

#ifdef FS_EDGE_TECH
#include "adf.h"
#endif

/** initialize a typeset from a font set */
FS_ULONG TYPESET_init(_DS_ TYPESET *typeset, FNTSET *fntset)
{
    CFNT *cfnt;
    FS_USHORT n;

    if (fntset)
    {
        /* grow TFNT array if needed */
        if (fntset->num_fonts > typeset->capacity)
        {
#ifdef FS_MEM_DBG
            STATE.memdbgid = "TFNT array";
#endif
            if (typeset->tfntarray) FSS_free(_PS_ typeset->tfntarray); /* no need to retain old data */
            typeset->tfntarray = (TFNT *)FSS_malloc(_PS_ fntset->num_fonts * sizeof(TFNT));
            if ((typeset->tfntarray == 0) || STATE.error)
                return STATE.error = ERR_MALLOC_FAIL;
            typeset->capacity = fntset->num_fonts;
        }

        /* signal font set in use */
        typeset->fntset = fntset;
        fntset->ref_count++;

        /* now load defaults */
        for (n = 0, cfnt = (CFNT *)(fntset->cfnt); n < fntset->num_fonts; n++, cfnt++)
        {
            typeset->tfntarray[n].cfnt = cfnt;
            typeset->tfntarray[n].sfnt = 0;              /* set in FSS_set_scale */
            typeset->tfntarray[n].cmap_offset = 0;       /* set in FSS_set_cmap  */
#ifdef FS_EDGE_RENDER
            /* set default Edge(TM) rendering parameters for this font      */
            /* values may be changed by FS_set_csm or by FS_set_scale       */
            adfSetDefaultRenderAttrs(&(typeset->tfntarray[n].adfRenderAttrs));
#endif
        }
    }
    else
    {
        typeset->capacity = 0;
        STATE.error = ERR_BAD_FNTSET;
        return STATE.error;
    }

    STATE.error = SUCCESS;
    return SUCCESS;
}

/** clear a typeset */
FS_ULONG TYPESET_clear(_DS_ TYPESET *typeset)
{
    FS_USHORT n;

    if (typeset == 0)
        return STATE.error = SUCCESS;

    STATE.error = SUCCESS;

    /* signal done using font set */
    if (typeset->fntset)
        typeset->fntset->ref_count--;

    /* clear references to sfnts */
    for (n = 0; n < typeset->capacity; n++)
    {
        if (typeset->tfntarray[n].sfnt)
        {
            typeset->tfntarray[n].sfnt->ref_count--;
            typeset->tfntarray[n].sfnt = 0;
        }
    }

    typeset->fntset = NULL;

    /* capacity does not change, only clearing contents */

    return STATE.error;
}

/** destroy a typeset's contents */
FS_ULONG TYPESET_destroy(_DS_ TYPESET *typeset)
{
    FS_USHORT n;

    if (typeset == 0)
        return STATE.error = SUCCESS;

    STATE.error = SUCCESS;

    /* signal done using font set */
    if (typeset->fntset)
    {
        typeset->fntset->ref_count--;
        typeset->fntset = NULL;
    }

    /* clear references to sfnts */
    for (n = 0; n < typeset->capacity; n++)
    {
        if (typeset->tfntarray[n].sfnt)
        {
            typeset->tfntarray[n].sfnt->ref_count--;
        }
    }

#ifdef FS_MEM_DBG
    STATE.memdbgid = "TFNT array";
#endif
    FSS_free(_PS_ typeset->tfntarray);
    typeset->tfntarray = 0;
    typeset->capacity = 0;

    return STATE.error;
}
/*********************************************************************************/
